/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets;

import com.beust.jcommander.Parameters;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import libsidplay.common.ChipModel;
import libsidplay.common.Emulation;
import server.restful.common.ContentTypeAndFileExtensions;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.UsageParameter;
import sidplay.ini.IniDefaults;

@WebServlet(name="FiltersServlet", displayName="FiltersServlet", urlPatterns={"/jsidplay2service/JSIDPlay2REST/filters"}, description="Get SID filter definitions")
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"user", "admin"}))
public class FiltersServlet
extends JSIDPlay2Servlet {
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            FiltersServletParameters servletParameters = new FiltersServletParameters();
            ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
            if (servletParameters.getHelp().booleanValue() || parser.hasException()) {
                parser.usage();
                return;
            }
            List<String> filters = this.getFilters();
            this.setOutput(ContentTypeAndFileExtensions.MIME_TYPE_JSON, response, filters);
        }
        catch (Throwable t) {
            response.setStatus(500);
            ServletUtil.error(this.getServletContext(), t, new Thread[0]);
            this.setOutput(response, t);
        }
    }

    private List<String> getFilters() {
        ArrayList<String> result = new ArrayList<String>();
        for (String filterName : IniDefaults.DEFAULTS.getFilterNames(Emulation.RESID, ChipModel.MOS6581)) {
            result.add("RESID_MOS6581_" + filterName);
        }
        for (String filterName : IniDefaults.DEFAULTS.getFilterNames(Emulation.RESID, ChipModel.MOS8580)) {
            result.add("RESID_MOS8580_" + filterName);
        }
        for (String filterName : IniDefaults.DEFAULTS.getFilterNames(Emulation.RESIDFP, ChipModel.MOS6581)) {
            result.add("RESIDFP_MOS6581_" + filterName);
        }
        for (String filterName : IniDefaults.DEFAULTS.getFilterNames(Emulation.RESIDFP, ChipModel.MOS8580)) {
            result.add("RESIDFP_MOS8580_" + filterName);
        }
        return result;
    }

    @Parameters(resourceBundle="server.restful.servlets.FiltersServletParameters")
    public static class FiltersServletParameters
    extends UsageParameter {
    }
}

